% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression.R
\name{ape}
\alias{ape}
\title{Absolute Percent Error}
\usage{
ape(actual, predicted)
}
\arguments{
\item{actual}{The ground truth numeric vector.}

\item{predicted}{The predicted numeric vector, where each element in the vector
is a prediction for the corresponding element in \code{actual}.}
}
\description{
\code{ape} computes the elementwise absolute percent difference between two numeric
vectors
}
\details{
\code{ape} is calculated as (\code{actual} - \code{predicted}) / \code{actual}.
This means that the function will return \code{-Inf}, \code{Inf}, or \code{NaN}
if \code{actual} is zero.
}
\examples{
actual <- c(1.1, 1.9, 3.0, 4.4, 5.0, 5.6)
predicted <- c(0.9, 1.8, 2.5, 4.5, 5.0, 6.2)
ape(actual, predicted)
}
\seealso{
\code{\link{mape}} \code{smape}
}
