% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MspecificCoxph.R
\name{MSpecificCoxPh}
\alias{MSpecificCoxPh}
\title{Metabolite by metabolite Cox proportional analysis}
\usage{
MSpecificCoxPh(Survival, Mdata, Censor, Reduce = FALSE, Select = 15,
  Prognostic = NULL, Quantile = 0.5)
}
\arguments{
\item{Survival}{A vector of survival time with length equals to number of subjects}

\item{Mdata}{A large or small metabolic profile matrix. A matrix with metabolic profiles where the number of rows should be equal to the number of metabolites and number of columns should be equal to number of patients.}

\item{Censor}{A vector of censoring indicator}

\item{Reduce}{A boolean parameter indicating if the metabolic profile matrix should be reduced, default is TRUE and larger metabolic profile matrix is reduced by supervised pca approach and first pca is extracted from the reduced matrix to be used in the classifier.}

\item{Select}{Number of metabolites (default is 15) to be selected from supervised PCA. This is valid only if the argument Reduce=TRUE}

\item{Prognostic}{A dataframe containing possible prognostic(s) factor and/or treatment effect to be used in the model.}

\item{Quantile}{The cut off value for the classifier, default is the median cutoff}
}
\value{
A object of class \code{\link[MetabolicSurv]{ms}} is returned with the following values
  \item{Result}{The cox proportional regression result for each metabolite}
  \item{HRRG}{The hazard ratio statistics (Hazard-ratio, Lower confidence interval and upper confidence interval) of the riskgroup based on the riskscore and the cut off value for each metabolite}
  \item{Group}{The classification of the subjects based on each metabolite analysis}
  \item{Metnames}{The names of the metabolites for the analysis}
}
\description{
The Function fits cox proportional hazard model and does classification for each metabolite
}
\details{
This function fits  metabolite by metabolite Cox proportional hazard model and perform the classification based on a speciied quantile risk score which has been estimated using a single  metabolite. Function is useful for majority vote classification method and  metabolite by  metabolite analysis and also for top K  metabolites.
}
\examples{
## FIRSTLY SIMULATING A METABOLIC SURVIVAL DATA
Data = MSData(nPatients = 100, nMet = 150, Prop = 0.5)

## USING THE FUNCTION
Example1 = MSpecificCoxPh(Survival = Data$Survival,
Mdata = t(Data$Mdata), Censor = Data$Censor, Reduce = FALSE,
Select = 15,Prognostic = Data$Prognostic, Quantile = 0.5)

## KNOWLING THE CLASS OF THE OUTPUT
class(Example1)

## EXTRACTING THE COMPONENT OF THE FUNCTION
### HAZARD RATIO INFORMATION FOR EACH METABOLITES
Example1@HRRG

### COX MODEL RESULT FOR EACH METABOLITES
Example1@Result

### CLASSIFICATION FOR EACH METABOLITES
Example1@Group
}
\seealso{
\code{\link[survival]{coxph}},  \code{\link[MetabolicSurv]{EstimateHR}}
}
\author{
Olajumoke Evangelina Owokotomo, \email{olajumoke.owokotomo@uhasselt.be}

Ziv Shkedy
}
