% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetFreq.R
\name{MetFreq}
\alias{MetFreq}
\title{Frequency of Selected Metabolites from the Metabolite specific Cross Validation}
\usage{
MetFreq(Object, TopK = 20, Minfreq = 5, N = 10)
}
\arguments{
\item{Object}{An object of class \code{\link[MetabolicSurv]{cvmm}} returned from the function \code{\link[MetabolicSurv]{CVMetSpecificCoxPh}}.}

\item{TopK}{The number of Top K metabolites (20 by default) to be used in the analysis}

\item{Minfreq}{The minimum frequency required for a particular meabolites to be included in the result.}

\item{N}{The number of Top N metabolites to be displayed in the frequency of selection graph}
}
\value{
A vector of metabolites and their frequency of selection. Also, a graphical representation is displayed.
}
\description{
The function selects the top K metabolites from the metabolite by metabolite cross validation, that is the number of times each metabolite occur during the cross-validation process. In case of large metabolomic matrix then the minfreq is required to select metabolites occurence more than a certain frequency. If the number specified is greater than the maximum frequency of seection then max(frequency)-1 will be automatically used as MinFreq.
}
\details{
This function outputs the mostly selected metabolites during the metabolite specific cross validation. Selected Top metabolites are ranked based on estimated HR for low risk group. Therefore top metabolites should have minimum HR estimates. Number of top K metabolites needed should be prespecified. In addition, it visualizes the selected top metabolites based on the minimum frequency specified..
}
\examples{
\donttest{
## FIRSTLY SIMULATING A METABOLIC SURVIVAL DATA
Data = MSData(nPatients = 100, nMet = 150, Prop = 0.5)

## METABOLITE SPECIFIC CROSS VALIDATION
Result = CVMetSpecificCoxPh(Fold=3,Survival=Data$Survival,
Mdata=t(Data$Mdata),Censor= Data$Censor,Reduce=FALSE,
Select=15,Prognostic=Data$Prognostic,Quantile = 0.5,Ncv=30)

## CONFIRMING THE CLASS
class(Result)

## USING THE FUNCTION
MetFreq(Result,TopK = 5,Minfreq = 20, N=5)
}
}
\seealso{
\code{\link[MetabolicSurv]{cvmm}}, \code{\link[survival]{coxph}},
\code{\link[MetabolicSurv]{EstimateHR}}, \code{\link[MetabolicSurv]{MSpecificCoxPh}},\code{\link[MetabolicSurv]{CVMetSpecificCoxPh}}
}
\author{
Olajumoke Evangelina Owokotomo, \email{olajumoke.owokotomo@uhasselt.be}

Ziv Shkedy
}
