% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstimateHR.R
\name{EstimateHR}
\alias{EstimateHR}
\title{Classification, Survival Estimation and Visualization}
\usage{
EstimateHR(Risk.Scores, Data.Survival, Prognostic = NULL,
  Plots = FALSE, Quantile = 0.5)
}
\arguments{
\item{Risk.Scores}{A vector of risk scores with size equals to number of subjects}

\item{Data.Survival}{A dataframe in which the first column is the Survival and the second column is the Censoring indicator for each subject.}

\item{Prognostic}{A dataframe containing possible prognostic(s) factor and/or treatment effect}

\item{Plots}{A boolean parameter indicating if plots should be shown. Default is FALSE}

\item{Quantile}{The cut off value for the classifier, default is the median cutoff}
}
\value{
An object of is returned, which is a list with the results of the cox regression and some informative plot concerning survival of the risk group.
  \item{SurvResult}{The cox proportional regression result}
  \item{Riskgroup}{The riskgroup based on the riskscore and the cut off value and length is equal to number of subjects}
  \item{KMplot}{The Kaplan-Meier survival plot of the riskgroup}
  \item{SurvBPlot}{The distribution of the survival in the riskgroup}
}
\description{
The Function  classifies subjects into Low and High risk group using the risk scores based on the cut-off percentile.It also visualize survival fit along with HR estimates.
}
\details{
The risk scores obtained using the signature is then used to generate the risk group by dividing subjects into low and high risk group. A Cox model is then fitted with the risk group as covariate in the presence or absence of  prognostic factors and or treatment effect. The extent of survival in the risk groups is known
}
\examples{
### Classification and estimating with prognostic factors
data(DataHR)
Result = EstimateHR(Risk.Scores=DataHR[,1],Data.Survival=DataHR[,2:3]
,Prognostic=DataHR[,4:5],Plots=FALSE,Quantile=0.50)

### Classification and estimating without prognostic factors
data(DataHR)
Result = EstimateHR(Risk.Scores=DataHR[,1],Data.Survival=DataHR[,2:3]
,Prognostic=NULL,Plots=FALSE,Quantile=0.50)
}
\seealso{
\code{\link[survival]{coxph}}
}
\author{
Olajumoke Evangelina Owokotomo, \email{olajumoke.owokotomo@uhasselt.be}

Ziv Shkedy
}
