% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Majorityvotes.R
\name{Majorityvotes}
\alias{Majorityvotes}
\title{Classifiction for Majority Votes}
\usage{
Majorityvotes(Result, Prognostic, Survival, Censor, J = 1)
}
\arguments{
\item{Result}{An object obtained from the metabolite specific analysis (\code{\link[MetabolicSurv]{MSpecificCoxPh}}) which is of class "ms"}

\item{Prognostic}{A dataframe containing possible prognostic(s) factor and/or treatment effect to be used in the model.}

\item{Survival}{A vector of survival time with length equals to number of subjects}

\item{Censor}{A vector of censoring indicator}

\item{J}{The jth set of patients required for the visualization. The default is J=1 which is the first set of patients. For visualization, J should be less than the number of patients divided by 25}
}
\value{
A list is returned with the following values
  \item{Model.result}{The cox proportional regression result based on the majority vote classification}
  \item{N}{The majority vote for each subject}
  \item{Classif}{The majority vote classification for each subjects}
  \item{Group}{The classification of the subjects based on each metabolite analysis}
}
\description{
The Function fits cox proportional hazard model and does classification based on the majority votes.
}
\details{
The Function fits cox proportional hazard model and does classification based on the majority votes while estimating the Hazard ratio of the low risk group. The function firstly count the number of Low risk classification for each subject based on the metabolite specific analysis which determ,ines the majority votes. In addition, It visualizes the metabolic specific calssification for the subjects. 25 ssubjects is taken for visualization purpose.
}
\examples{
## FIRSTLY SIMULATING A METABOLIC SURVIVAL DATA
Data = MSData(nPatients = 100, nMet = 150, Prop = 0.5)

## RUNNING THE METABOLITE SPECIFIC FUNCTION
Example1 = MSpecificCoxPh(Survival = Data$Survival,
Mdata = t(Data$Mdata), Censor = Data$Censor, Reduce = FALSE,
Select = 15,Prognostic = Data$Prognostic, Quantile = 0.5)

## USING THE FUNCTION
Result2 = Majorityvotes(Example1,Data$Prognostic, Data$Survival,Data$Censor,J=2)

## THE SURVIVAL ANALYSIS FOR MAJORITY VOTE RESULT
 Result2$Model.result

### THE MAJORITY VOTE FOR EACH SUBJECT
Result2$N

### THE MAJORITY VOTE CLASSIFICATION FOR EACH SUBJECT
Result2$Classif

### THE GROUP FOR EACH SUBJECT BASED ON THE METABOLITE SPPECIFIC ANALYSIS
Result2$Group
}
\references{
\insertRef{tib}{MetabolicSurv}
}
\seealso{
\code{\link[MetabolicSurv]{MSpecificCoxPh}}, \code{\link[survival]{coxph}},  \code{\link[MetabolicSurv]{EstimateHR}}
}
\author{
Olajumoke Evangelina Owokotomo, \email{olajumoke.owokotomo@uhasselt.be}

Ziv Shkedy
}
