% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MBMA_stan.R
\name{MBMA_stan}
\alias{MBMA_stan}
\title{Fitting a model-based meta-analysis model using Stan}
\usage{
MBMA_stan(data = NULL, Pred_doses = NULL, model = "AB_Emax",
  mu_prior = c(0, 10), Emax_prior = c(0, 10), ED50_prior = c(0, 10),
  tau_prior = 0.5, tau_prior_dist = "half-normal", chains = 4,
  iter = 2000, warmup = 1000, adapt_delta = 0.95)
}
\arguments{
\item{data}{An object of `create_MBMA_dat`.}

\item{Pred_doses}{A numerical vector specfying the doses which prediction will be made.
Default is NULL.}

\item{model}{A string specifying the model used. Available options are `Baseline_Emax`
(Baseline random effects model (\emph{Boucher and Bennets, 2016)}), `CB_Emax`
(contrast-based random effects model (\emph{Mawdsley et al ,2016)}), `AB_Emax`
(arm-based random effects model, adapted from (\emph{Zhang et al ,2017)}), `CBPlusBaseline_Emax`
(contrast-based plus baseline random effects model, adapted from (\emph{Dias et al ,2013)}).
Default is `AB_Emax`.}

\item{mu_prior}{A numerical vector specifying the parameter of the normal prior
density for baseline risks, first value is parameter for mean, second is for variance.
Default is c(0, 10).}

\item{Emax_prior}{A numerical vector specifying the parameter of the normal prior
density for Emax parameter, first value is parameter for mean, second
is for standard devation. Default is c(0, 10).}

\item{ED50_prior}{A numerical vector specifying the parameter of the normal prior
density for ED50 parameter, first value is parameter for mean, second
is for standard devation. Default is c(0, 10).}

\item{tau_prior}{A numerical value specifying the standard dev. of the prior density
for heterogenety stdev. Default is 0.5.}

\item{tau_prior_dist}{A string specifying the prior density for the heterogeneity standard deviation,
option is `half-normal` for half-normal prior, `uniform` for uniform prior, `half-cauchy` for
half-cauchy prior.}

\item{chains}{A positive integer specifying the number of Markov chains.
The default is 4.}

\item{iter}{A positive integer specifying the number of iterations for each chain
(including warmup). The default is 2000.}

\item{warmup}{A positive integer specifying the number of warmup (aka burnin)
iterations per chain. The default is 1000.}

\item{adapt_delta}{A numerical value specfying the target average proposal acceptance
probability for adaptation. See Stan manual for details. Default is 0.95. In general
you should not need to change adapt_delta unless you see a warning message about
divergent transitions, in which case you can increase adapt_delta from the
default to a value closer to 1 (e.g. from 0.95 to 0.99, or from 0.99 to 0.999, etc).}
}
\value{
an object of class `stanfit` returned by `rstan::sampling`
}
\description{
`MBMA_stan` fits a model-based meta-analysis model using Stan.
}
\examples{
\donttest{
## Load the dataset
data('dat.Eletriptan', package = "MetaStan")
## Fitting a Binomial-Normal Hierarchial model using WIP priors
datMBMA = create_MBMA_dat(dat = dat.Eletriptan,
                         armVars = c(dose = "d", responders = "r",
                                     sampleSize = "n"),
                         nArmsVar = "nd")

MBMA.AB.Emax  <- MBMA_stan(data = datMBMA,
                          model = "AB_Emax",
                          Pred_doses = seq(0, 80, length.out = 11),
                          Emax_prior = c(0, 10),
                          tau_prior_dist = "half-normal",
                          tau_prior = 0.5)
}

}
\references{
Boucher M, et al. The many flavors of model-based meta-analysis:
Part I-Introduction and landmark data. \emph{CPT: Pharmacometrics & Systems Pharmacology}.
2016;5:54–64.

Mawdsley D, et al. Model-based network meta-analysis: A
framework for evidence synthesis of clinical trial data.
\emph{CPT: Pharmacometrics & Systems Pharmacology}. 2016;5:393-401.

Zhang J, et al. (2014). Network meta-analysis of randomized
clinical trials: Reporting the proper summaries. \emph{Clinical Trials}.
11(2), 246–262.

Dias S, et al. Absolute or relative effects?
Arm-based synthesis of trial data. \emph{Research Synthesis Methods}.
2016;7:23–28.
}
