% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{g_layout}
\alias{g_layout}
\alias{g_layout_nice}
\title{Layout with group}
\usage{
g_layout(
  go,
  group = "module",
  group_order = NULL,
  layout1 = in_circle(),
  zoom1 = 20,
  layout2 = in_circle(),
  zoom2 = 3,
  show_big_layout = FALSE,
  ...
)

g_layout_nice(go, group = "module", mode = "circlepack", ...)
}
\arguments{
\item{go}{igraph or metanet}

\item{group}{group name (default: module)}

\item{group_order}{group_order}

\item{layout1}{layout1 method, one of
(1) a dataframe or matrix: rowname is group, two columns are X and Y
(2) function: layout method for \code{\link{c_net_layout}} default: in_circle()}

\item{zoom1}{big network layout size}

\item{layout2}{one of functions: layout method for \code{\link{c_net_layout}}, or a list of functions.}

\item{zoom2}{average sub_network layout size, or numeric vector, or "auto"}

\item{show_big_layout}{show the big layout to help you adjust.}

\item{...}{add}

\item{mode}{circlepack, treemap, backbone, stress}
}
\value{
coors
}
\description{
Layout with group

Layout with group nicely
}
\examples{
\donttest{
data("c_net")
module_detect(co_net, method = "cluster_fast_greedy") -> co_net_modu
g_layout(co_net_modu, group = "module", zoom1 = 30, zoom2 = "auto", layout2 = as_line()) -> oridata
plot(co_net_modu, coors = oridata)
}
\donttest{
data("c_net")
module_detect(co_net, method = "cluster_fast_greedy") -> co_net_modu
if (requireNamespace("ggraph")) {
  plot(co_net_modu, coors = g_layout_nice(co_net_modu, group = "module"))
  plot(co_net_modu, coors = g_layout_nice(co_net_modu, group = "module", mode = "treemap"))
}
}
}
\seealso{
Other g_layout: 
\code{\link{g_layout_polygon}()}
}
\concept{g_layout}
