% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oxy-db_base.R
\name{cleanDB}
\alias{cleanDB}
\title{Uniformize database and remove invalid formulas/SMILES}
\usage{
cleanDB(db.formatted, cl, silent = TRUE, blocksize, smitype = "Canonical")
}
\arguments{
\item{db.formatted}{Data table with columns 'compoundname, structure, baseformula, charge, description'}

\item{cl}{parallel::makeCluster object for multithreading}

\item{silent}{Suppress warnings?}

\item{blocksize}{How many compounds to process per 'block'? Higher number means bigger memory spikes, but faster processing time.}

\item{smitype}{SMILES format, Default: 'Canonical'}
}
\value{
Data table with SMILES in the correct format, and charge/formula re-generated from said SMILES if available.
}
\description{
This is a wrapper function to take a 'raw' input data table with compound information, uniformize the SMILES
}
\examples{
\dontrun{myDB = build.LMDB(tempdir())}
\dontrun{cleanedDB = cleanDB(myDB$db, cl = 0, blocksize = 10)}
}
\seealso{
\code{\link[parallel]{clusterApply}}
 \code{\link[pbapply]{pbapply}}
 \code{\link[enviPat]{check_chemform}}
 \code{\link[data.table]{rbindlist}}
}
