% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oxy-from_formula.R
\name{getPredicted}
\alias{getPredicted}
\title{Get predicted formulas and adducts from m/z value}
\usage{
getPredicted(
  mz,
  ppm = 2,
  mode = "positive",
  rules = c("senior", "lewis", "hc", "chnops", "nops"),
  elements = c("C", "H", "N", "O", "P", "S"),
  search = c("PubChem", "ChemSpider"),
  detailed = TRUE,
  calc_adducts = adducts[Ion_mode == mode, ]$Name,
  adduct_table = adducts
)
}
\arguments{
\item{mz}{M/z of interest}

\item{ppm}{Error margin in parts per million, Default: 2}

\item{mode}{M/z found in positive or negative mode?, Default: 'positive'}

\item{rules}{Which golden rules to apply?, Default: c("senior", "lewis", "hc", "chnops", "nops")}

\item{elements}{Which elements to consider?, Default: c("C", "H", "N", "O", "P", "S")}

\item{search}{Check the found formulas on PubChem or ChemSpider?, Default: c("PubChem", "ChemSpider")}

\item{detailed}{Look up details like description etc. if hit found? Makes things slower!, Default: TRUE}

\item{calc_adducts}{Which adducts to consider?, Default: adducts[Ion_mode == mode, ]$Name}

\item{adduct_table}{Adduct table to use, referred to by 'calc_adducts'. Allows use for custom 'adducts' such as in-source fragments etc.}
}
\value{
Table of found matches and associated info
}
\description{
Wrapper function to predict formulas and then consider adducts as well.
}
\examples{
\dontrun{getPredicted(mz = 170, ppm = 2, mode = "positive",
rules = c("hc", "chnops", "nops"),
elements = c("C","H","O"))}
}
\seealso{
\code{\link[data.table]{rbindlist}}
 \code{\link[enviPat]{check_chemform}}
}
