% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeBarPlots.R
\name{makeBarPlots}
\alias{makeBarPlots}
\title{Generate Bar Plots for the Seven Evaluation Measures}
\usage{
makeBarPlots(evalMeasuresDF, emNames = "All")
}
\arguments{
\item{evalMeasuresDF}{A dataframe with the following columns: Model, RepNum, PosClass.FScore, PosClass.Recall, PosClass.Precision,
NegClass.FScore, NegClass.Recall, NegClass.Precision, and Accuracy. The rows of the dataframe will correspond to the results of
a particular model and a particular round of cross-validation.}

\item{emNames}{A list of names of the evaluation measures to visualize. Accepts the following: PosClass.FScore, PosClass.Recall,
PosClass.Precision, NegClass.FScore, NegClass.Recall, NegClass.Precision, and Accuracy. Default is "All".}
}
\value{
A list of up to seven bar plots (one for each evaluation measure).
}
\description{
Wrapper function for generating bar plots for each classifiers for each of the seven evaluation measures.
}
\examples{
# Create a list of bar plots for each evaluation measure
\donttest{makeBarPlots(evalMeasuresDF = test_evalMeasures)}

}
