% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculatePeakSignificanceLevel.R
\name{calculatePeakSignificanceLevel}
\alias{calculatePeakSignificanceLevel}
\title{Calculate Peak Significance Level (of a Chromatographic Peak)}
\usage{
calculatePeakSignificanceLevel(peakData, pts)
}
\arguments{
\item{peakData}{A vector containing characteristic information about a chromatographic peak - including the retention time range}

\item{pts}{A 2D matrix containing the retention time and intensity values of a chromatographic peak}
}
\value{
The Peak Significance Level (double)
}
\description{
Calculates the Peak Significance Level of the integrated region of a chromatographic peak. The Peak Significance Level is found by
calculating the ratio of the mean intensity of the points surrounding the apex and the mean intensity of the peak boundary points.
}
\details{
This function repurposed from Zhang et al. For details, see Zhang, W., & Zhao, P. X. (2014). Quality evaluation of extracted
ion chromatograms and chromatographic peaks in liquid chromatography/mass spectrometry-based metabolomics data. BMC Bioinformatics,
15(Suppl 11), S5. https://doi.org/10.1186/1471-2105-15-S11-S5
}
\examples{
# Calculate Peak Significance for a peak
data(ex_pts)
data(ex_peakData)
peakSignificance <- calculatePeakSignificanceLevel(peakData = ex_peakData, pts = ex_pts)

}
