% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetAlyzer_handler.R
\name{exportConcValues}
\alias{exportConcValues}
\title{Export filtered raw data as csv}
\usage{
exportConcValues(metalyzer_se, ..., file_path = "metabolomics_data.csv")
}
\arguments{
\item{metalyzer_se}{SummarizedExperiment}

\item{...}{Additional columns from meta_data}

\item{file_path}{file path}
}
\description{
This function exports the filtered raw data in the CSV format.
}
\examples{
metalyzer_se <- MetAlyzer_dataset(file_path = example_extraction_data())

output_file <- file.path(tempdir(), "metabolomics_data.csv")
exportConcValues(
  metalyzer_se,
  `Sample Description`,
  Tissue,
  file_path = output_file
)
unlink(output_file)
}
