% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mega2genabel.R
\name{Mega2GenABEL}
\alias{Mega2GenABEL}
\title{generate gwaa.data-class object from a \bold{Mega2R} database}
\usage{
Mega2GenABEL(markers = NULL, mapno = 0, envir = ENV)
}
\arguments{
\item{markers}{data frame of markers to be processed}

\item{mapno}{specify which map index to use for physical distances}

\item{envir}{'environment' containing SQLite database and other globals}
}
\value{
gwaa.data-class object generated from the Mega2R database
}
\description{
Call the \emph{Mega2R} functions to: create a .tped file, a .tfam file and a .phe file.
 Then call the GenABEL functions to process these files: the .tped and the .tfam
 file are processed by \code{convert.snp.tped} to produce a tped.raw file.  The latter
 is combined with a .phe (phenotype) file by \code{load.gwaa.data} to create a gwaa.data-class
 object in memory.  All these files are deleted when the exits.
}
\examples{
db = system.file("exdata", "seqsimm.db", package="Mega2R")
ENV = read.Mega2DB(db)
seqsimgwaa = Mega2GenABEL(markers=ENV$markers[1:10,])

str(seqsimgwaa)
head(summary(seqsimgwaa))

}
