% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mts_slice.R
\name{mts_slice_head}
\alias{mts_slice_head}
\alias{mts_slice_tail}
\title{Subset time series based on their position}
\usage{
mts_slice_head(mts, n = 5)

mts_slice_tail(mts, n = 5)
}
\arguments{
\item{mts}{\emph{mts} object.}

\item{n}{Number of rows of \code{mts$meta} to select.}
}
\value{
A subset of the incoming \emph{mts} time series object.
(A list with \code{meta} and \code{data} dataframes.)
}
\description{
An \emph{mts} object is reduced so as to contain only the first
or last \code{n} timeseries. These functions work similarly to
\code{\link[dplyr:slice_head]{dplyr::slice_head}} and
\code{\link[dplyr:slice_tail]{dplyr::slice_tail}}
but apply to both dataframes in the \emph{mts} object.

This is primarily useful when the \emph{mts} object has been ordered by a
previous call to \code{\link{mts_arrange}} or by some other means.

\code{slice_head()} selects the first and \code{slice_tail()} the last timeseries
in the object.
}
\examples{
library(MazamaTimeSeries)

# Find lowest elevation sites
Camp_Fire \%>\%
  mts_filterMeta(!is.na(elevation)) \%>\%
  mts_arrange(elevation) \%>\%
  mts_slice_head(n = 5) \%>\%
  mts_extractMeta() \%>\%
  dplyr::select(elevation, locationName)

# Find highest elevation sites
Camp_Fire \%>\%
  mts_filterMeta(!is.na(elevation)) \%>\%
  mts_arrange(elevation) \%>\%
  mts_slice_tail(n = 5) \%>\%
  mts_extractMeta() \%>\%
  dplyr::select(elevation, locationName)

}
