% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-sampling.R
\name{.sample}
\alias{.sample}
\title{General table row sampling}
\usage{
.sample(data, sampleSize = NULL, sampleFraction = NULL, seed = NULL)
}
\arguments{
\item{data}{Dataframe to be sampled.}

\item{sampleSize}{Non-negative integer giving the number of rows to choose.}

\item{sampleFraction}{Fraction of rows to sample.}

\item{seed}{Integer passed to \code{\link[base]{set.seed}} for reproducible sampling.}
}
\value{
A data.frame
}
\description{
This is a wrapper around \code{\link[base]{sample}} to make it
easy to select random rows from a table. Supports either integer
(\code{sampleSize}) or fractional (\code{sampleFraction}) row sampling.
For reproducible debugging, specify \code{seed}.

If both \code{sampleSize} and \code{sampleFraction} are specified,
\code{sampleSize} takes precedence.

Specifying \code{sampleSize} greater than the number of rows in the
dataframe or \code{sampleFraction > 1} will use all rows.
}
\keyword{internal}
