% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/US_stateConversion.R
\name{US_stateConversion}
\alias{US_stateConversion}
\alias{US_stateCodeToName}
\alias{US_stateCodeToFIPS}
\alias{US_stateFIPSToName}
\alias{US_stateCodeToCode}
\alias{US_stateNameToCode}
\alias{US_stateNameToFIPS}
\alias{US_stateFIPSToCode}
\title{Conversion functions for US state names, codes and FIPS codes.}
\usage{
US_stateCodeToName(stateCode = NULL)

US_stateCodeToFIPS(stateCode = NULL)

US_stateFIPSToName(stateFIPS = NULL)

US_stateFIPSToCode(stateFIPS = NULL)

US_stateNameToCode(stateName = NULL)

US_stateNameToFIPS(stateName = NULL)
}
\arguments{
\item{stateCode}{Vector of ISO 3166-2 alpha-2 codes.}

\item{stateFIPS}{Vector of two-digit FIPS codes.}

\item{stateName}{Vector of English language state names.}
}
\value{
A vector of US state names or codes.
}
\description{
Converts a vector of US state names or codes from one system to
another reuturning \code{NA} where no match is found.
}
\examples{
library(MazamaSpatialUtils)

US_stateNameToCode("Washington")
US_stateNameToFIPS("Washington")

postalCodes <- sample(US_stateCodes$stateCode, 30)

data.frame(
  name = US_stateCodeToName(postalCodes),
  code = postalCodes,
  FIPS = US_stateCodeToFIPS(postalCodes)
)

}
