% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertWikipediaTimezoneTable.R
\name{convertWikipediaTimezoneTable}
\alias{convertWikipediaTimezoneTable}
\title{Convert Wikipedia Timezone Table to Dataframe}
\usage{
convertWikipediaTimezoneTable()
}
\value{
Dataframe with 388 rows and 10 columns.
}
\description{
Returns a dataframe version of the Wikipedia timezone table with
the following columns:

\itemize{
  \item{timezone -- Olson timezone}
  \item{UTC_offset -- hours between local timezone and UTC}
  \item{UTC_DST_offset -- hours between local timezone daylight savings and UTC}
  \item{countryCode -- ISO 3166-2 country code}
  \item{longitude -- longitude of the Olson timezone city}
  \item{latitude -- latitude of the Olson timezone city}
  \item{status -- either 'Canonical', 'Alias' or 'Deprecated'}
  \item{notes -- typically specifying the target of an 'Alias'}
}
}
\details{
Older named timezones from the table which are linked to more modern
equivalents are not included in the returned dataframe.
}
\references{
\url{https://en.wikipedia.org/wiki/List_of_tz_database_time_zones}
}
\keyword{datagen}
