% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/convertWorldTimezones.R
\name{convertWorldTimezones}
\alias{convertWorldTimezones}
\title{Create Timezone Dataset}
\usage{
convertWorldTimezones(nameOnly = FALSE)
}
\arguments{
\item{nameOnly}{logical specifying whether to only return the name without creating the file}
}
\value{
Name of the dataset being created.
}
\description{
A world timezone shapefile is downloaded from \url{http://efele.net/maps/tz/world/}
and converted to a SpatialPolygonsDataFrame with additional columns of data. The resulting file will be created
in the package \code{SpatialDataDir} which can be set with \code{setSpatialDataDir()}.
}
\note{
The following list of timezones have polygons but the associated rows in the dataframe have no data.
These timezones also have no \code{countryCode} assigned. We hope to rectify this in a future release.
\preformatted{
> WorldTimezones@data$timezone[is.na(WorldTimezones$countryCode)]
[1] "Europe/Zagreb"         "Europe/Vatican"        "America/Coral_Harbour"
[4] "Arctic/Longyearbyen"   "uninhabited"           "America/Kralendijk"
[7] "Europe/Jersey"         "Europe/Bratislava"     "America/St_Barthelemy"
[10] "Europe/Ljubljana"      "Europe/Mariehamn"      "Europe/Podgorica"
[13] "Europe/Isle_of_Man"    "Europe/Guernsey"       "Europe/San_Marino"
[16] "Europe/Skopje"         "Europe/Sarajevo"       "America/Lower_Princes"
[19] "America/Marigot"       "Africa/Juba"
}
}
\seealso{
setSpatialDataDir

convertWikipediaTimezoneTable
}
\keyword{datagen}

