% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anlzMWRmap.R
\name{anlzMWRmap}
\alias{anlzMWRmap}
\title{Analyze results with maps}
\usage{
anlzMWRmap(
  res = NULL,
  param,
  acc = NULL,
  sit = NULL,
  fset = NULL,
  site = NULL,
  resultatt = NULL,
  locgroup = NULL,
  dtrng = NULL,
  ptsize = 4,
  repel = TRUE,
  labsize = 3,
  palcol = "Greens",
  palcolrev = FALSE,
  sumfun = "auto",
  crs = 4326,
  zoom = 11,
  addwater = "medium",
  watercol = "lightblue",
  maptype = NULL,
  buffdist = 2,
  scaledist = "km",
  northloc = "tl",
  scaleloc = "br",
  latlon = TRUE,
  ttlsize = 1.2,
  runchk = TRUE,
  warn = TRUE
)
}
\arguments{
\item{res}{character string of path to the results file or \code{data.frame} for results returned by \code{\link{readMWRresults}}}

\item{param}{character string of the parameter to plot, must conform to entries in the \code{"Simple Parameter"} column of \code{\link{paramsMWR}}}

\item{acc}{character string of path to the data quality objectives file for accuracy or \code{data.frame} returned by \code{\link{readMWRacc}}}

\item{sit}{character string of path to the site metadata file or \code{data.frame} of site metadata returned by \code{\link{readMWRsites}}}

\item{fset}{optional list of inputs with elements named \code{res}, \code{acc}, \code{frecom}, \code{sit}, or \code{wqx} overrides the other arguments}

\item{site}{character string of sites to include, default all}

\item{resultatt}{character string of result attributes to plot, default all}

\item{locgroup}{character string of location groups to plot from the \code{"Location Group"} column in the site metadata file, default all}

\item{dtrng}{character string of length two for the date ranges as YYYY-MM-DD, default all}

\item{ptsize}{numeric for size of the points, use a negative value to omit the points}

\item{repel}{logical indicating if overlapping site labels are offset}

\item{labsize}{numeric for size of the site labels}

\item{palcol}{character string indicating the color palette to be used from \href{https://r-graph-gallery.com/38-rcolorbrewers-palettes.html}{RColorBrewer}, see details}

\item{palcolrev}{logical indicating if color palette in \code{palcol} is reversed}

\item{sumfun}{character indicating one of \code{"auto"} (default), \code{"mean"}, \code{"geomean"}, \code{"median"}, \code{"min"}, or \code{"max"}, see details}

\item{crs}{numeric as a four-digit EPSG number for the coordinate reference system, see details}

\item{zoom}{numeric indicating resolution of the base map, see details}

\item{addwater}{character string as \code{"low"}, \code{"medium"} (default), \code{"high"}, or \code{NULL} (to suppress) to include water features with varying detail from the National Hydrography dataset, see details}

\item{watercol}{character string of color for water objects if \code{addwater} is not \code{NULL}}

\item{maptype}{character string as \code{"cartolight"}, \code{"cartodark"}, \code{"osm"}, \code{"hotstyle"}, or \code{NULL} (to suppress, default) indicating the basemap type, see details}

\item{buffdist}{numeric for buffer around the bounding box for the selected sites in kilometers, see details}

\item{scaledist}{character string indicating distance unit for the scale bar, \code{"km"} or \code{"mi"}}

\item{northloc}{character string indicating location of the north arrow, see details}

\item{scaleloc}{character string indicating location of the scale bar, see details}

\item{latlon}{logical to include latitude and longitude labels on the plot, default \code{TRUE}}

\item{ttlsize}{numeric value indicating font size of the title relative to other text in the plot}

\item{runchk}{logical to run data checks with \code{\link{checkMWRresults}}, \code{\link{checkMWRacc}}, or \code{\link{checkMWRsites}}, applies only if \code{res}, \code{acc}, or \code{sit} are file paths}

\item{warn}{logical to return warnings to the console (default)}
}
\value{
A \code{\link[ggplot2]{ggplot}} object that can be further modified.
}
\description{
Analyze results with maps
}
\details{
This function creates a map of summarized results for a selected parameter at each monitoring site.  By default, all dates for the parameter are averaged. Options to filter by site, date range, and result attribute are provided.  Only sites with spatial information in the site metadata file are plotted and a warning is returned for those that do not have this information. The site labels are also plotted next to each point.  The labels can be suppressed by setting \code{labsize = NULL}.

Any acceptable color palette from \href{https://r-graph-gallery.com/38-rcolorbrewers-palettes.html}{RColorBrewer} can be used for \code{palcol}, which is passed to the \code{palette} argument in \code{\link[ggplot2]{scale_fill_distiller}}. These could include any of the sequential color palettes, e.g., \code{"Greens"}, \code{"Blues"}, etc.  The diverging and qualitative palettes will also work, but may return uninterpretable color scales. The palette can be reversed by setting \code{palcolrev = TRUE}.

The default value for \code{crs} is EPSG 4326 for the WGS 84 projection in decimal degrees.  The \code{crs} argument is passed to \code{\link[sf]{st_as_sf}} and any acceptable CRS appropriate for the data can be used.

The results shown on the map represent the parameter summary for each site within the date range provided by \code{dtrng}.  If \code{sumfun = "auto"} (default), the mean is used where the distribution is determined automatically from the data quality objective file for accuracy, i.e., parameters with "log" in any of the columns are summarized with the geometric mean, otherwise arithmetic. Any other valid summary function will be applied if passed to \code{sumfun} (\code{"mean"}, \code{"geomean"}, \code{"median"}, \code{"min"}, \code{"max"}), regardless of the information in the data quality objective file for accuracy.

Using \code{addwater = "medium"} (default) will include lines and polygons of natural water bodies defined using the National Hydrography Dataset (NHD). The level of detail can be changed to low or high using \code{addwater = "low"} or \code{addwater = "high"}, respectively.  Use \code{addwater = NULL} to not show any water features.

A base map can be plotted using the \code{maptype} argument and is obtained from the \code{\link[ggspatial]{annotation_map_tile}} function of ggspatial.  The \code{zoom} value specifies the resolution of the map.  Use higher values to download map tiles with greater resolution, although this increases the download time.  The \code{maptype} argument describes the type of base map to download. Acceptable options include \code{"cartolight"}, \code{"cartodark"}, \code{"osm"}, or \code{"hotstyle"}. Use \code{maptype = NULL} to suppress the base map.

The area around the summarized points can be increased or decreased using the \code{buffdist} argument.  This creates a buffered area around the bounding box for the points, where the units are kilometers.

A north arrow and scale bar are also placed on the map as defined by the \code{northloc} and \code{scaleloc} arguments.  The placement for both can be chosen as \code{"tl"}, \code{"tr"}, \code{"bl"}, or \code{"br"} for top-left, top-right, bottom-left, or bottom-right respectively.  Setting either of the arguments to \code{NULL} will suppress the placement on the map.
}
\examples{
# results data path
respth <- system.file('extdata/ExampleResults.xlsx', package = 'MassWateR')

# results data
resdat <- readMWRresults(respth)

# accuracy path
accpth <- system.file('extdata/ExampleDQOAccuracy.xlsx', package = 'MassWateR')

# accuracy data
accdat <- readMWRacc(accpth)

# site data path
sitpth <- system.file('extdata/ExampleSites.xlsx', package = 'MassWateR')

# site data
sitdat <- readMWRsites(sitpth)

\donttest{
# map with NHD water bodies
anlzMWRmap(res = resdat, param = 'DO', acc = accdat, sit = sitdat, addwater = 'medium')
}
}
