% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_CForestModel.R
\name{CForestModel}
\alias{CForestModel}
\title{Conditional Random Forest Model}
\usage{
CForestModel(
  teststat = c("quad", "max"),
  testtype = c("Univariate", "Teststatistic", "Bonferroni", "MonteCarlo"),
  mincriterion = 0,
  ntree = 500,
  mtry = 5,
  replace = TRUE,
  fraction = 0.632
)
}
\arguments{
\item{teststat}{character specifying the type of the test statistic to be
applied.}

\item{testtype}{character specifying how to compute the distribution of the
test statistic.}

\item{mincriterion}{value of the test statistic that must be exceeded in
order to implement a split.}

\item{ntree}{number of trees to grow in a forest.}

\item{mtry}{number of input variables randomly sampled as candidates at each
node for random forest like algorithms.}

\item{replace}{logical indicating whether sampling of observations is done
with or without replacement.}

\item{fraction}{fraction of number of observations to draw without
replacement (only relevant if \code{replace = FALSE}).}
}
\value{
\code{MLModel} class object.
}
\description{
An implementation of the random forest and bagging ensemble algorithms
utilizing conditional inference trees as base learners.
}
\details{
\describe{
  \item{Response types:}{\code{factor}, \code{numeric}, \code{Surv}}
  \item{\link[=TunedModel]{Automatic tuning} of grid parameter:}{
    \code{mtry}
  }
}

Supplied arguments are passed to \code{\link[party]{cforest_control}}.
Further model details can be found in the source link below.
}
\examples{
fit(sale_amount ~ ., data = ICHomes, model = CForestModel)

}
\seealso{
\code{\link[party]{cforest}}, \code{\link{fit}},
\code{\link{resample}}
}
