% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{TuningGrid}
\alias{TuningGrid}
\title{Tuning Grid Control}
\usage{
TuningGrid(size = 3, random = FALSE)
}
\arguments{
\item{size}{single integer or vector of integers whose positions or names
match the parameters in a model's tuning grid and which specify the number
of values used to construct the grid.}

\item{random}{number of unique points to sample at random from the grid
defined by \code{size}.  If \code{size} is a single unnamed integer, then
\code{random = Inf} will include all values of all grid parameters in the
constructed grid, whereas \code{random = FALSE} will include all values of
default grid parameters.}
}
\value{
\code{TuningGrid} class object.
}
\description{
Defines control parameters for a tuning grid.
}
\details{
Returned \code{TuningGrid} objects may be supplied to
\code{\link{TunedModel}} for automated construction of model tuning grids.
These grids can be extracted manually and viewed with the
\code{\link{expand_modelgrid}} function.
}
\examples{
TunedModel(XGBTreeModel, grid = TuningGrid(10, random = 5))

}
\seealso{
\code{\link{TunedModel}}, \code{\link{expand_modelgrid}}
}
