% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff.R
\name{t.test}
\alias{t.test}
\alias{t.test.PerformanceDiff}
\title{Paired t-Tests for Model Comparisons}
\usage{
\method{t.test}{PerformanceDiff}(x, adjust = "holm", ...)
}
\arguments{
\item{x}{performance \link[=diff]{difference} result.}

\item{adjust}{p-value adjustment for multiple statistical comparisons as
implemented by \code{\link[stats]{p.adjust}}.}

\item{...}{arguments passed to other methods.}
}
\value{
\code{PerformanceDiffTest} class object that inherits from
\code{array}.  p-values and mean differences are contained in the lower and
upper triangular portions, respectively, of the first two dimensions.  Model
pairs are contined in the third dimension.
}
\description{
Paired t-test comparisons of resampled performance metrics from different
models.
}
\examples{
\donttest{
## Requires prior installation of suggested package gbm to run

## Numeric response example
fo <- sale_amount ~ .
control <- CVControl()

gbm_res1 <- resample(fo, ICHomes, GBMModel(n.trees = 25), control)
gbm_res2 <- resample(fo, ICHomes, GBMModel(n.trees = 50), control)
gbm_res3 <- resample(fo, ICHomes, GBMModel(n.trees = 100), control)

res <- c(GBM1 = gbm_res1, GBM2 = gbm_res2, GBM3 = gbm_res3)
res_diff <- diff(res)
t.test(res_diff)
}

}
