% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_GAMBoostModel.R
\name{GAMBoostModel}
\alias{GAMBoostModel}
\title{Gradient Boosting with Additive Models}
\usage{
GAMBoostModel(
  family = NULL,
  baselearner = c("bbs", "bols", "btree", "bss", "bns"),
  dfbase = 4,
  mstop = 100,
  nu = 0.1,
  risk = c("inbag", "oobag", "none"),
  stopintern = FALSE,
  trace = FALSE
)
}
\arguments{
\item{family}{optional \code{\link[mboost]{Family}} object.  Set
automatically according to the class type of the response variable.}

\item{baselearner}{character specifying the component-wise
\code{\link[mboost:baselearners]{base learner}} to be used.}

\item{dfbase}{gobal degrees of freedom for P-spline base learners
(\code{"bbs"}).}

\item{mstop}{number of initial boosting iterations.}

\item{nu}{step size or shrinkage parameter between 0 and 1.}

\item{risk}{method to use in computing the empirical risk for each boosting
iteration.}

\item{stopintern}{logical inidicating whether the boosting algorithm stops
internally when the out-of-bag risk increases at a subsequent iteration.}

\item{trace}{logical indicating whether status information is printed during
the fitting process.}
}
\value{
\code{MLModel} class object.
}
\description{
Gradient boosting for optimizing arbitrary loss functions, where
component-wise arbitrary base-learners, e.g., smoothing procedures, are
utilized as additive base-learners.
}
\details{
\describe{
  \item{Response Types:}{\code{binary factor}, \code{BinomialVariate},
    \code{NegBinomialVariate}, \code{numeric}, \code{PoissonVariate},
    \code{Surv}}
  \item{\link[=TunedModel]{Automatic Tuning} of Grid Parameters:}{
    \code{mstop}
  }
}

Default values for the \code{NULL} arguments and further model details can be
found in the source links below.
}
\examples{
\donttest{
## Requires prior installation of suggested package mboost to run

data(Pima.tr, package = "MASS")

fit(type ~ ., data = Pima.tr, model = GAMBoostModel)
}

}
\seealso{
\code{\link[mboost]{gamboost}}, \code{\link[mboost]{Family}},
\code{\link[mboost]{baselearners}}, \code{\link{fit}},
\code{\link{resample}}
}
