% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff.R
\name{diff}
\alias{diff}
\alias{diff.MLModelTune}
\alias{diff.Performance}
\alias{diff.Resamples}
\title{Model Performance Differences}
\usage{
\method{diff}{MLModelTune}(x, ...)

\method{diff}{Performance}(x, ...)

\method{diff}{Resamples}(x, ...)
}
\arguments{
\item{x}{model \link{tune}, \link{performance}, or \link{resample} result.}

\item{...}{arguments passed to other methods.}
}
\value{
\code{PerformanceDiff} class object that inherits from
\code{Performance}.
}
\description{
Pairwise model differences in resampled performance metrics.
}
\examples{
## Survival response example
library(survival)
library(MASS)

fo <- Surv(time, status != 2) ~ sex + age + year + thickness + ulcer
control <- CVControl()

gbm_res1 <- resample(fo, Melanoma, GBMModel(n.trees = 25), control)
gbm_res2 <- resample(fo, Melanoma, GBMModel(n.trees = 50), control)
gbm_res3 <- resample(fo, Melanoma, GBMModel(n.trees = 100), control)

res <- Resamples(GBM1 = gbm_res1, GBM2 = gbm_res2, GBM3 = gbm_res3)
res_diff <- diff(res)
summary(res_diff)
plot(res_diff)

}
\seealso{
\code{\link{t.test}}, \code{\link{plot}}, \code{\link{summary}}
}
