% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confusion.R
\name{confusion}
\alias{confusion}
\alias{Confusion}
\alias{ConfusionMatrix}
\title{Confusion Matrix}
\usage{
confusion(x, y = NULL, cutoff = MachineShop::settings("cutoff"),
  na.rm = TRUE, ...)

Confusion(...)

ConfusionMatrix(object = numeric(), ordered = FALSE)
}
\arguments{
\item{x}{factor of \link[=response]{observed responses} or \link{resample}
result containing observed and predicted responses.}

\item{y}{\link[=predict]{predicted responses} if not contained in \code{x}.}

\item{cutoff}{numeric (0, 1) threshold above which binary factor
probabilities are classified as events and below which survival
probabilities are classified.  If \code{NULL}, then binary responses are
summed directly over predicted class probabilities, whereas a default
cutoff of 0.5 is used for survival probabilities.  Class probability
summations and survival will appear as decimal numbers that can be
interpreted as expected counts.}

\item{na.rm}{logical indicating whether to remove observed or predicted
responses that are \code{NA} when calculating metrics.}

\item{...}{named or unnamed \code{confusion} output to combine together with
the \code{Confusion} constructor.}

\item{object}{square matrix, or object that can be converted to one, of
cross-classified predicted and observed values in the rows and columns,
respectively.}

\item{ordered}{logical indicating whether the confusion matrix row and
columns should be regarded as ordered.}
}
\value{
The return value is a \code{ConfusionMatrix} class object that inherits from
\code{table} if \code{x} and \code{y} responses are specified or a
\code{Confusion} object that inherits from \code{list} if \code{x} is a
\code{Resamples} object.
}
\description{
Calculate confusion matrices of predicted and observed responses.
}
\examples{
res <- resample(Species ~ ., data = iris, model = GBMModel)
(conf <- confusion(res))
plot(conf)

}
\seealso{
\code{\link{plot}}, \code{\link{summary}}
}
