% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_MDAModel.R
\name{MDAModel}
\alias{MDAModel}
\title{Mixture Discriminant Analysis Model}
\usage{
MDAModel(subclasses = 3, sub.df = NULL, tot.df = NULL,
  dimension = sum(subclasses) - 1, eps = .Machine$double.eps,
  iter = 5, method = .(mda::polyreg), trace = FALSE, ...)
}
\arguments{
\item{subclasses}{numeric value or vector of subclasses per class.}

\item{sub.df}{effective degrees of freedom of the centroids per class if
subclass centroid shrinkage is performed.}

\item{tot.df}{specification of the total degrees of freedom as an alternative
to \code{sub.df}.}

\item{dimension}{dimension of the discriminant subspace to use for
prediction.}

\item{eps}{numeric threshold for automatically truncating the dimension.}

\item{iter}{limit on the total number of iterations.}

\item{method}{regression function used in optimal scaling.  The default of
linear regression is provided by \code{\link[mda]{polyreg}} from the
\pkg{mda} package.  For penalized mixture discriminant models,
\code{\link[mda]{gen.ridge}} is appropriate.  Other possibilities are
\code{\link[mda]{mars}} for multivariate adaptive regression splines and
\code{\link[mda]{bruto}} for adaptive backfitting of additive splines.  Use
the \code{\link[MachineShop:dot-]{.}} operator to quote specified
functions.}

\item{trace}{logical indicating whether iteration information is printed.}

\item{...}{additional arguments to \code{mda.start} and \code{method}.}
}
\value{
\code{MLModel} class object.
}
\description{
Performs mixture discriminant analysis.
}
\details{
\describe{
  \item{Response Types:}{\code{factor}}
  \item{\link[=TunedModel]{Automatic Tuning} of Grid Parameters:}{
    \code{subclasses}
  }
}

The \code{\link{predict}} function for this model additionally accepts the
following argument.
\describe{
  \item{\code{prior}}{prior class membership probabilities for prediction data
    if different from the training set.}
}

Default values for the \code{NULL} arguments and further model details can be
found in the source links below.
}
\examples{
fit(Species ~ ., data = iris, model = MDAModel)

}
\seealso{
\code{\link[mda]{mda}}, \code{\link[mda]{predict.mda}},
\code{\link{fit}}, \code{\link{resample}}, \code{\link{tune}}
}
