% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLMetric.R
\name{MLMetric}
\alias{MLMetric}
\alias{MLMetric<-}
\title{MLMetric Class Constructor}
\usage{
MLMetric(object, name = "MLMetric", label = name, maximize = TRUE)

MLMetric(object) <- value
}
\arguments{
\item{object}{function to compute the metric.  Must be defined to accept
\code{observed} and \code{predicted} as the first two arguments and with an
ellipsis (\code{...}) to accommodate others.}

\item{name}{character string name for the instantiated \code{MLMetric}
object; same as the metric function name.}

\item{label}{descriptive label for the metric.}

\item{maximize}{logical indicating whether to maximize the metric for better
performance.}

\item{value}{list of arguments to pass to the \code{MLMetric} constructor.}
}
\value{
\code{MLMetric} class object.
}
\description{
Create a performance metric for use with the \pkg{MachineShop} package.
}
\examples{
f2_score <- function(observed, predicted, ...) {
  f_score(observed, predicted, beta = 2, ...)
}

MLMetric(f2_score) <- list(name = "f2_score",
                           label = "F Score (beta = 2)",
                           maximize = TRUE)

}
\seealso{
\code{\link{metrics}}, \code{\link{metricinfo}}
}
