% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metrics}
\alias{metrics}
\alias{accuracy}
\alias{brier}
\alias{cindex}
\alias{cross_entropy}
\alias{f_score}
\alias{gini}
\alias{kappa2}
\alias{mae}
\alias{mse}
\alias{msle}
\alias{npv}
\alias{ppv}
\alias{pr_auc}
\alias{precision}
\alias{r2}
\alias{recall}
\alias{rmse}
\alias{rmsle}
\alias{roc_auc}
\alias{roc_index}
\alias{sensitivity}
\alias{specificity}
\alias{weighted_kappa2}
\title{Performance Metrics}
\usage{
accuracy(observed, predicted = NULL, cutoff = 0.5, times = numeric(),
  ...)

brier(observed, predicted = NULL, times = numeric(), ...)

cindex(observed, predicted = NULL, ...)

cross_entropy(observed, predicted = NULL, ...)

f_score(observed, predicted = NULL, cutoff = 0.5, times = numeric(),
  beta = 1, ...)

gini(observed, predicted = NULL, ...)

kappa2(observed, predicted = NULL, cutoff = 0.5, times = numeric(),
  ...)

mae(observed, predicted = NULL, ...)

mse(observed, predicted = NULL, ...)

msle(observed, predicted = NULL, ...)

npv(observed, predicted = NULL, cutoff = 0.5, times = numeric(), ...)

ppv(observed, predicted = NULL, cutoff = 0.5, times = numeric(), ...)

pr_auc(observed, predicted = NULL, times = numeric(), ...)

precision(observed, predicted = NULL, cutoff = 0.5,
  times = numeric(), ...)

r2(observed, predicted = NULL, ...)

recall(observed, predicted = NULL, cutoff = 0.5, times = numeric(),
  ...)

rmse(observed, predicted = NULL, ...)

rmsle(observed, predicted = NULL, ...)

roc_auc(observed, predicted = NULL, times = numeric(), ...)

roc_index(observed, predicted = NULL, cutoff = 0.5,
  times = numeric(), f = function(sens, spec) sens + spec, ...)

sensitivity(observed, predicted = NULL, cutoff = 0.5,
  times = numeric(), ...)

specificity(observed, predicted = NULL, cutoff = 0.5,
  times = numeric(), ...)

weighted_kappa2(observed, predicted = NULL, power = 1, ...)
}
\arguments{
\item{observed}{observed responses or
\code{\link[=confusion]{ConfusionMatrix}} of observed and predicted
responses.}

\item{predicted}{predicted responses.}

\item{cutoff}{threshold above which binary factor probabilities are
classified as events and below which survival probabilities are classified.}

\item{times}{numeric vector of follow-up times at which survival events
were predicted.}

\item{...}{arguments passed to or from other methods.}

\item{beta}{relative importance of recall to precision in the calculation of
\code{f_score} [default: F1 score].}

\item{f}{function to calculate a desired sensitivity-specificity tradeoff.}

\item{power}{power to which positional distances of off-diagonals from the
main diagonal in confusion matrices are raised to calculate
\code{weighted_kappa2}.}
}
\description{
Compute measures of agreement between observed and predicted responses.
}
\seealso{
\code{\link{metricinfo}}, \code{\link{confusion}},
\code{\link{performance}}
}
