% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/calibration.R
\name{calibration}
\alias{calibration}
\alias{Calibration}
\title{Model Calibration}
\usage{
Calibration(...)

calibration(x, y = NULL, n = 10, times = numeric(), ...)
}
\arguments{
\item{...}{named or unnamed \code{calibration} output to combine together
with the \code{Calibration} constructor.}

\item{x}{observed responses or \code{Resamples} object of observed and
predicted responses.}

\item{y}{predicted responses.}

\item{n}{number of resampled response variable bins within which to
calculate observed mean values.}

\item{times}{numeric vector of follow-up times if \code{y} contains predicted
survival events.}
}
\value{
\code{Calibration} class object that inherits from \code{data.frame}.
}
\description{
Calculate calibration estimates from observed and predicted responses.
}
\examples{
library(survival)
library(MASS)

res <- resample(Surv(time, status != 2) ~ sex + age + year + thickness + ulcer,
                data = Melanoma, model = GBMModel,
                control = CVControl(surv_times = 365 * c(2, 5, 10)))
(cal <- calibration(res))
plot(cal)

}
\seealso{
\code{\link{response}}, \code{\link{predict}},
\code{\link{resample}}, \code{\link{plot}}
}
