% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varimp.R
\name{varimp}
\alias{varimp}
\title{Variable Importance}
\usage{
varimp(object, scale = TRUE, ...)
}
\arguments{
\item{object}{\code{MLModelFit} object from a model fit.}

\item{scale}{logical indicating whether importance measures should be scaled
to range from 0 to 100.}

\item{...}{arguments passed to model-specific variable importance functions.}
}
\value{
\code{VarImp} class object.
}
\description{
Calculate measures of the relative importance of predictors in a model.
}
\examples{
## Survival response example
library(survival)
library(MASS)

gbmfit <- fit(Surv(time, status != 2) ~ sex + age + year + thickness + ulcer,
              data = Melanoma, model = GBMModel)
(vi <- varimp(gbmfit))
plot(vi)

}
\seealso{
\code{\link{fit}}, \code{\link{plot}}
}
