% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{Resamples}
\alias{Resamples}
\title{Resamples Class Contructor}
\usage{
Resamples(..., control = NULL, response = NULL)
}
\arguments{
\item{...}{named or unnamed resample output from one or more models.}

\item{control}{MLControl object used to generate the resample output.}

\item{response}{data frame of resampled observed and predicted resposnes.}
}
\value{
Resamples class object.
}
\description{
Create an object of resampled performance metrics from one or more models.
}
\details{
Argument \code{control} need only be specified if the supplied
output is not a Resamples object.  Output being combined from more than one
model must have been generated with the same resampling object and
performance metrics.
}
\examples{
## Factor response example

fo <- Species ~ .
control <- CVControl()

gbmperf1 <- resample(fo, iris, GBMModel(n.trees = 25), control)
gbmperf2 <- resample(fo, iris, GBMModel(n.trees = 50), control)
gbmperf3 <- resample(fo, iris, GBMModel(n.trees = 100), control)

perf <- Resamples(GBM1 = gbmperf1, GBM2 = gbmperf2, GBM3 = gbmperf3)
summary(perf)
plot(perf)

}
\seealso{
\code{\link{resample}}, \code{\link{plot}}, \code{\link{summary}}
}
