% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict}
\alias{predict}
\alias{predict.MLModelFit}
\title{Model Prediction}
\usage{
\method{predict}{MLModelFit}(object, newdata, type = c("response",
  "prob"), cutoff = 0.5, times = NULL, ...)
}
\arguments{
\item{object}{MLModelFit object from a model fit.}

\item{newdata}{data frame with which to obtain predictions.}

\item{type}{specifies prediction on the original outcome scale
(\code{"response"}) or on a probability distribution scale (\code{"prob"}).}

\item{cutoff}{threshold above which probabilities are classified as success
for factor outcomes and which expected values are rounded for integer
outcomes.}

\item{times}{numeric vector of follow-up times at which to predict
survival events.}

\item{...}{arguments passed to model-specific prediction functions.}
}
\description{
Predict outcomes with a fitted model.
}
\examples{
## Survival response example
library(survival)

gbmfit <- fit(Surv(time, status) ~ age + sex + ph.ecog + ph.karno +
                                   pat.karno + meal.cal + wt.loss,
              data = lung, GBMModel)
predict(gbmfit, lung, times = c(180, 360, 540), type = "prob")

}
\seealso{
\code{\link{fit}}, \code{\link{modelmetrics}}
}
