% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot}
\alias{plot}
\alias{plot.MLModelTune}
\alias{plot.Resamples}
\alias{plot.VarImp}
\title{Model Performance Plots}
\usage{
\method{plot}{MLModelTune}(x, metrics = NULL, stat = mean,
  type = c("boxplot", "density", "errorbar", "line", "violin"), ...)

\method{plot}{Resamples}(x, metrics = NULL, stat = mean,
  type = c("boxplot", "density", "errorbar", "violin"), ...)

\method{plot}{VarImp}(x, n = NULL, ...)
}
\arguments{
\item{x}{object to plot.}

\item{metrics}{vector of numeric indexes or character names of the performance
metrics to plot.}

\item{stat}{function to compute a summary statistic on resampled values for
MLModelTune line plots and Resamples model sorting.  The supplied function
should contain a \code{na.rm} argument in its definition.}

\item{type}{type of plot to construct.}

\item{...}{arguments passed to other methods.}

\item{n}{number of most important variables to include in the plot
(default: all).}
}
\description{
Plot measures of model performance and predictor variable importance.
}
\examples{
## Factor response example

fo <- factor(Species) ~ .
control <- CVControl()

gbmfit <- fit(fo, iris, GBMModel, control)
plot(varimp(gbmfit))

gbmperf1 <- resample(fo, iris, GBMModel(n.trees = 25), control)
gbmperf2 <- resample(fo, iris, GBMModel(n.trees = 50), control)
gbmperf3 <- resample(fo, iris, GBMModel(n.trees = 100), control)
plot(gbmperf3)

perf <- Resamples(GBM1 = gbmperf1, GBM2 = gbmperf2, GBM3 = gbmperf3)
plot(perf)

}
\seealso{
\code{\link{diff}}, \code{\link{resample}}, \code{\link{Resamples}},
\code{\link{tune}}

\code{\link{varimp}}
}
