% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcga.cn.convert.R
\name{tcga.cn.convert}
\alias{tcga.cn.convert}
\title{A Function for Reformatting TCGA DNA Copy Number Matrices}
\usage{
tcga.cn.convert(cn.mat)
}
\arguments{
\item{cn.mat}{A matrix of DNA copy number data included in the GISTIC2 output.  Typically all_data_by_genes.txt, or a subset thereof,
including the Locus.ID and Cytoband columns.}
}
\value{
A matrix of DNA copy number data (rows = genes, columns = samples) that is suitable for input to 
 mVisAGe functions.
}
\description{
This function reformats DNA copy number matrices obtained from the Broad Institute's Firehose GDAC 
 (\url{https://gdac.broadinstitute.org/}) so they can be used as input for mVisAGe functions.
}
\examples{
cn.mat = tcga.cn.convert(cn.mat)

}
