% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mardia.R
\name{mardia}
\alias{mardia}
\title{Mardia's Test for Multivariate Normality}
\usage{
mardia(data, use_population = TRUE, tol = 1e-25)
}
\arguments{
\item{data}{A numeric matrix or data frame with observations in rows and variables in columns.}

\item{use_population}{Logical; if \code{TRUE}, uses the population covariance estimator \eqn{\frac{n-1}{n} \times \Sigma}; otherwise uses the sample covariance. Default is \code{TRUE}.}

\item{tol}{Numeric tolerance passed to \code{\link[base]{solve}} when inverting the covariance matrix.
Default is \code{1e-25}.}
}
\value{
A data frame with two rows, one for Mardia's skewness test and one for the kurtosis test.
Each row contains the name of the test (\code{Test}), the test statistic (\code{Statistic}),
and the associated p-value (\code{p.value}).
}
\description{
Performs Mardia’s skewness and kurtosis tests to assess multivariate normality
in a multivariate dataset.
}
\examples{
\dontrun{
data <- iris[1:50, 1:4]
mardia_result <- mardia(data)
mardia_result
}

}
