% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvlm.R
\name{summary.mvlm}
\alias{summary.mvlm}
\title{Summarizing mvlm Results}
\usage{
\method{summary}{mvlm}(object, ...)
}
\arguments{
\item{object}{Output from \code{mvlm}}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Calling
\code{summary(mvlm.res)} produces a data frame comprised of:
\item{Statistic}{Value of the corresponding test statistic.}
\item{Numer DF}{Numerator degrees of freedom for each test statistic.}
\item{Pseudo R2}{Size of the corresponding (omnibus or conditional) effect
on the multivariate outcome. Note that the intercept term does not have
an estimated effect size.}
\item{p-value}{The p-value for each (omnibus or conditional) effect.}
In addition to the information in the three columns comprising
\code{summary(mvlm.res)}, the \code{mvlm.res} object also contains:

\item{p.prec}{A data.frame reporting the precision of each p-value.
These are the maximum error bound of the p-values reported by the
\code{davies} function in \code{CompQuadForm}.}
\item{y.rsq}{A matrix containing in its first row the overall variance
explained by the model for variable comprising Y (columns). The remaining
rows list the variance of each outcome that is explained by the conditional
effect of each predictor.}
\item{beta.hat}{Estimated regression coefficients.}
\item{adj.n}{Adjusted sample size used to determine whether or not the
asmptotic properties of the model are likely to hold. See McArtor et al.
(under review) for more detail.}
\item{data}{Original input data and the \code{model.matrix} used to fit the
model.}

Note that the printed output of \code{summary(res)} will truncate p-values
to the smallest trustworthy values, but the object returned by
\code{summary(mvlm.res)} will contain the p-values as computed. If the error
bound of the Davies algorithm is larger than the p-value, the only conclusion
that can be drawn with certainty is that the p-value is smaller than (or
 equal to) the error bound.
}
\description{
\code{summary} method for class \code{mvlm}
}
\examples{
data(mvlmdata)

Y <- as.matrix(Y.mvlm)

# Main effects model
mvlm.res <- mvlm(Y ~ Cont + Cat + Ord, data = X.mvlm)
summary(mvlm.res)

# Include two-way interactions
mvlm.res.int <- mvlm(Y ~ .^2, data = X.mvlm)
summary(mvlm.res.int)

}
\author{
Daniel B. McArtor (dmcartor@nd.edu) [aut, cre]
}
\references{
Davies, R. B. (1980). The Distribution of a Linear Combination of
 chi-square Random Variables. Journal of the Royal Statistical Society.
 Series C (Applied Statistics), 29(3), 323-333.

 Duchesne, P., & De Micheaux, P.L. (2010). Computing the distribution of
 quadratic forms: Further comparisons between the Liu-Tang-Zhang
 approximation and exact methods. Computational Statistics and Data
 Analysis, 54(4), 858-862.

 McArtor, D. B., Lubke, G. H., & Bergeman, C. S. (under review). The null
 distribution of the multivariate linear model test statistic. Manuscript
 submitted for publication.
}

