% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RT.R
\name{RT}
\alias{RT}
\title{Function to generate a unit space for the Recognition-Taguchi (RT) method}
\usage{
RT(unit_space_data, includes_transformed_data = FALSE, ...)
}
\arguments{
\item{unit_space_data}{Matrix with n rows (samples) and p columns (variables).
Data to generate the unit space. All data should be
continuous values and should not have missing values.}

\item{includes_transformed_data}{If \code{TRUE}, then the transformed data
are included in a return object.}

\item{...}{Passed to \code{\link[base]{solve}} for computing the inverse of
the correlation matrix.}
}
\value{
\code{RT} returns an object of S3 \link[base]{class} "RT". An
          object of class "RT" is a list containing the following components:

 \item{A}{2 x 2 matrix. Inversed correlation matrix of the transformed
           \code{unit_space_data}.}
 \item{calc_A}{\code{function(x) solve(cor(x), ...)}.}
 \item{transforms_data}{Function to be generated from
                         \code{\link{generates_dimensionality_reduction_function}}
                         based on \code{unit_space_data}.}
 \item{distance}{Vector with length n. Distances from the unit space to each
                  sample.}
 \item{n}{The number of samples.}
 \item{q}{The number of variables after the data transformation. q is always
           2.}
 \item{x}{If \code{includes_transformed_data} is \code{TRUE}, then the
           transformed data are included.}
}
\description{
\code{RT} generates a unit space for the Recognition-Taguchi (RT) method. In
  \code{\link{general_MT}}, the inversed correlation matrix is used for A and
  the data are transformed by the function to be generated by
  \code{\link{generates_dimensionality_reduction_function}} based on
  \code{unit_space_data}. In the transformation, the p variables in
  \code{unit_space_data} are reduced into 2 synthetic variables.
}
\examples{
# 40 data for versicolor in the iris dataset
iris_versicolor <- iris[61:100, -5]

unit_space_RT <- RT(unit_space_data = iris_versicolor,
                    includes_transformed_data = TRUE)

# The following "tol" is a parameter passed to the solve function.
unit_space_RT <- RT(unit_space_data = iris_versicolor,
                    includes_transformed_data = TRUE,
                    tol = 1e-9)

(unit_space_RT$distance)

}
\references{
Taguchi, G. (2006). Objective Function and Generic Function (11).
    \emph{Journal of Quality Engineering Society, 14}(2), 5-9. (In Japanese)

  Huda, F., Kajiwara, I., Hosoya, N., & Kawamura, S. (2013). Bolt loosening
   analysis and diagnosis by non-contact laser excitation vibration tests.
   \emph{Mechanical systems and signal processing, 40}(2), 589-604.
}
\seealso{
\code{\link[base]{solve}}, \code{\link{general_MT}},
           \code{\link{generates_dimensionality_reduction_function}}, and
           \code{\link{diagnosis.MT}}
}

