% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LAD.R
\name{LADlasso}
\alias{LADlasso}
\title{LAD-Lasso for Linear Regression}
\usage{
LADlasso(
  X,
  y,
  beta.ini,
  lambda = NULL,
  adaptive = TRUE,
  intercept = FALSE,
  penalty.factor = rep(1, ncol(X))
)
}
\arguments{
\item{X}{design matrix, standardization is recommended.}

\item{y}{reponse vector}

\item{beta.ini}{initial estimates of beta. Using unpenalized LAD is recommended under high-dimensional setting.}

\item{lambda}{regularization parameter of Lasso or adaptive Lasso (if adaptive=TRUE).}

\item{adaptive}{logical input that indicates if adaptive Lasso is used. Default is TRUE.}

\item{intercept}{logical input that indicates if intercept needs to be estimated. Default is FALSE.}

\item{penalty.factor}{can be used to force nonzero coefficients. Default is rep(1, ncol(X)) as in glmnet.}
}
\value{
\item{beta}{the regression coefficient estimates.}
\item{fitted}{predicted response.}
\item{iter.steps}{iteration steps.}
}
\description{
LAD-Lasso for Linear Regression
}
\examples{
set.seed(2017)
n=200; d=50
X=matrix(rnorm(n*d), nrow=n, ncol=d)
beta=c(rep(2,6), rep(0, 44))
y=X\%*\%beta+c(rnorm(150), rnorm(30,10,10), rnorm(20,0,100))
output.LADLasso=LADlasso(X, y, beta.ini=LAD(X, y))
beta.est=output.LADLasso$beta

}
