% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{data}
\name{com}
\alias{com}
\title{Grand Paris Metropole Communes Data}
\format{
A data frame with 150 rows and 10 variables:
\describe{
\item{DEPCOM}{Commune identifiers}
\item{LIBCOM}{Commune names}
\item{EPT}{EPT identifiers of the commune}
\item{LIBEPT}{EPT names of the commune}
\item{DEP}{Identifiers of the departement}
\item{INC}{Amount of income tax reference (in euros)}
\item{TH}{Number of tax households}
\item{geometry}{Commune geometry}
}
}
\source{
Direction générale des finances publiques, income tax 2014 (2013 incomes):\cr
\url{https://www.impots.gouv.fr/statistiques}\cr
Atelier parisien d'urbanisme, Grand Paris communal composition (2015-12-17):\cr
\url{https://www.apur.org/fr/nos-travaux/composition-12-territoires-metropole-grand-paris}
}
\description{
Data on the Grand Paris Metropole communes, included in a sf object.
}
\examples{
library(sf)
com <- st_read(system.file("metroparis.gpkg", package = "MTA"), layer = "com", quiet = TRUE)
}
