% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSmix_functions_package.R
\name{spear_dist}
\alias{spear_dist}
\title{Spearman distance}
\usage{
spear_dist(
  rankings,
  rho = NULL,
  subset = NULL,
  diag = FALSE,
  upper = FALSE,
  plot_dist_mat = FALSE
)
}
\arguments{
\item{rankings}{Integer \eqn{N}\eqn{\times}{x}\eqn{n} matrix with full rankings in each row.}

\item{rho}{An optional full ranking whose Spearman distance from each row of \code{rankings} must be computed. Defaults to \code{NULL}, meaning that the Spearman distance matrix between all pairs of rows in \code{rankings} must be computed.}

\item{subset}{Optional logical or integer vector specifying the subset of observations, i.e. rows of the \code{rankings}, to be kept. Missing values are taken as \code{FALSE}.}

\item{diag}{Logical: whether the diagonal of the Spearman distance matrix must be returned. Used when \code{rho = NULL}. Defaults to \code{FALSE}.}

\item{upper}{Logical: whether the upper triangle of the Spearman distance matrix must be printed. Used when \code{rho = NULL}. Defaults to \code{FALSE}.}

\item{plot_dist_mat}{Logical: whether the Spearman distance matrix must be plotted. Used when \code{rho = NULL}. Defaults to \code{FALSE}.}
}
\value{
When \code{rho = NULL}, an object of class \code{"dist"} corresponding to the Spearman distance matrix; otherwise, a vector with the Spearman distances between each row in \code{rankings} and \code{rho}.
}
\description{
Compute either the Spearman distance between each row of a full ranking matrix and a reference complete ranking, or the Spearman distance matrix between the rows of a full ranking matrix.
}
\details{
When \code{rho = NULL}, \code{spear_dist} recalls the \code{\link{dist}} function from the \code{base} package to compute the squared Euclidian distance between full rankings; otherwise, it recalls the \code{\link{compute_rank_distance}} routine of the \code{BayesMallows} package, which implements several metrics for rankings.
}
\examples{

## Example 1. Spearman distance between two full rankings.
spear_dist(rankings = c(4, 8, 6, 9, 2, 11, 3, 5, 1, 12, 7, 10), rho = 1:12)

## Example 2. Spearman distance between the Antifragility ranking dataset and the Borda ranking.
borda <- rank(data_description(rankings = ranks_antifragility)$mean_rank)
spear_dist(rankings = ranks_antifragility, rho = borda)

## Example 3. Spearman distance matrix of the Sports ranking dataset.
n <- 8
dist_mat <- spear_dist(rankings = ranks_sports[, 1:n])
dist_mat
# Spearman distance matrix for the subsample of females.
dist_f <- spear_dist(rankings = ranks_sports[, 1:n], subset = ranks_sports$Gender == "Female")
dist_f

}
\references{
Sørensen Ø, Crispino M, Liu Q and Vitelli V (2020). BayesMallows: An R Package for the Bayesian Mallows Model. \emph{The R Journal}, \bold{12}(1), pages 324--342, DOI: 10.32614/RJ-2020-026.
}
\seealso{
\code{\link{plot.dist}}, \code{\link[BayesMallows]{compute_rank_distance}}
}
