% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeQuartetDist.R
\name{quartetDist}
\alias{quartetDist}
\title{Compute quartet distance between taxa}
\usage{
quartetDist(dqt)
}
\arguments{
\item{dqt}{an (\code{n} choose 4) x \code{n} (or \code{n+1}) matrix of form output by \code{quartetTableDominant};
(Note: If present, the \code{n+1}th column of \code{dqt} is ignored.)}
}
\value{
a pairwise distance matrix on \code{n} taxa
}
\description{
Compute the Quartet Distance of \insertCite{Rho19;textual}{MSCquartets} from a table specifying a collection of quartets on
\code{n} taxa.
}
\examples{
gtrees=read.tree(file=system.file("extdata","dataGeneTreeSample",package="MSCquartets"))
tnames=taxonNames(gtrees)
QT=quartetTable(gtrees,tnames[1:6])
RQT=quartetTableResolved(QT)
DQT=quartetTableDominant(RQT)
Dist=quartetDist(DQT)
tree=NJ(Dist)
write.tree(tree)
plot(tree)

}
\references{
\insertRef{Rho19}{MSCquartets}
}
\seealso{
\code{\link{quartetTableDominant}},
\code{\link{QDS}},
\code{\link{QDC}},
\code{\link{quartetWeightedDist}}
}
