% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ToBtoLevel1.R
\name{blobDistance}
\alias{blobDistance}
\title{Compute empirical distance between taxon groups.}
\usage{
blobDistance(pTable, taxa, groupvec, test = "T3", alpha, beta, dist = "NANUQ")
}
\arguments{
\item{pTable}{table of giving empirical gene quartet counts for the taxa on tree, with columns p_star and p_test}

\item{taxa}{a list of taxon names, who positions are used in 'groups'}

\item{groupvec}{taxon groups encoded in vector}

\item{test}{to be used for detecting hybridizations in quartete ("T3" or "cut")}

\item{alpha}{test level for p_test}

\item{beta}{test level for p_star}

\item{dist}{the distance to compute, either "NANUQ" or "modNANUQ"}
}
\value{
the distance matrix, ordered by taxon group number
}
\description{
From gene quartet counts, computes NANUQ or modNANUQ distances between groups
of taxa (which should be those around a multifurcation in a tree of blobs.
If these groups are not singletons, averaging is done over group elements.
}
