% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MRmediation.R
\name{mediation}
\alias{mediation}
\title{A causal mediation method with methylated region as the mediator}
\usage{
mediation(
  pheno,
  predictor,
  region,
  pos,
  order,
  gbasis,
  covariate,
  base = "bspline",
  family = "gaussian"
)
}
\arguments{
\item{pheno}{A vector of continuous or binary phenotypes (class: numeric).}

\item{predictor}{A vector of values for the exposure variable (class: numeric).}

\item{region}{A matrix of CpGs in a region. Each column is a CpG (class: data.frame).}

\item{pos}{A vector of CpG locations from the defined region and they are from the same chromosome (class: integer).}

\item{order}{A value for the order of bspline basis. 1: constant, 2: linear, 3: quadratic and 4: cubic.}

\item{gbasis}{A value for the number of basis being used for functional transformation on CpGs.}

\item{covariate}{A matrix of covariates. Each column is a covariate (class: data.frame).}

\item{base}{"bspline" for B-spline basis or "fspline" for Fourier basis.}

\item{family}{"gaussian" for continuous outcome or "binomial" for binary outcome.}
}
\value{
1. pval$TE:   total effect (TE) p-value \cr
        2. pval$DE:   direct effect (DE) p-value \cr
        3. pval$IE:   indirect effect (IE) p-value \cr
        4. pval_MX:   p-value for the association between methylation and exposure \cr
}
\description{
A causal mediation method with methylated region as the mediator
}
\examples{
################
### Examples ###
################
data("example_data")
predictor = data$exposure
region = data[,7:dim(data)[2]]
covariates = subset(data, select=c("age","gender"))
# binary outcome
pheno_bin = data$pheno_bin
mediation(pheno_bin, predictor, region, pos, covariate=covariates, order=4, 
gbasis=4, base="bspline", family="binomial")
# continuous outcome 
pheno_con = data$pheno_con
mediation(pheno_con, predictor, region, pos, covariate=covariates, order=4, 
gbasis=4, base="bspline", family="gaussian")
}
