% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateDevelopmentLags.R
\name{CreateDevelopmentLags}
\alias{CreateDevelopmentLags}
\title{Create triangle development lags}
\usage{
CreateDevelopmentLags(LagValues, DevelopmentPeriod = months(1),
  EvaluationDates = NULL, OriginPeriods = NULL, Verbose = TRUE)
}
\arguments{
\item{LagValues}{Vector of development lags}

\item{DevelopmentPeriod}{A period object indicating the common time period between evaluations}

\item{EvaluationDates}{A vector of evaluation dates}

\item{OriginPeriods}{A vector of origin periods}

\item{Verbose}{Show warnings?}
}
\value{
A vector of intervals
}
\description{
If the triangle dataframe does not record development lags as lubridate periods, they must be 
created. 
Development lags may be established one of three ways:
1. The development lags are passed in as lubridate periods.
   Everything's cool. The evaluation dates are established by adding the periods to the starting 
   point
   of the origin periods.
2. The development lags are passed in as integers, with a presumed time period.
   The program will establish lubridate period objects using the integers and time periods and then 
   proceed 
   as above.
3. An evaluation date is passed in. Here we must take the difference between the evaluation dates
   and the origin periods. We will assume months as the default period. The user may pass in another.
}
\seealso{
\code{\link{CreateDevelopmentLags}}, \code{\link{CreateEvaluationDates}}
}

