% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.r
\docType{data}
\name{tasab}
\alias{tasab}
\title{tasab is a matrix of abalone maturity-at-length data}
\format{A data.frame of maturity-at-length data
\describe{
  \item{site}{an identifier for the two different sites sampled}
  \item{sex}{I = immature, M = male, F = female}
  \item{length}{the shell length in mm}
  \item{mature}{was the animal mature = 1 or not = 0}
}}
\source{
Many thanks to the Institute of Marine and Antarctic Science, 
    which is part of the University of Tasmania, and especially to 
    Dr Craig Mundy, leader of the Abalone Group, for permission to use 
    this data collected in February 1995.
}
\description{
tasab is a 715 x 4 matrix of maturity-at-length data
    for blacklip abalone (\emph{Haliotis rubra}) from two sites 
    along the Tasmanian west coast. All data was collected in 
    February 1995, but details, such as site name, accurate 
    location, statistical block, year, month, and other 
    details have been omitted for brevity. See section on maturity
    within the Static Models chapter for detailed use of this
    data-set.
}
\section{Subjects}{

 \itemize{
   \item maturity ogives or logistic curves
   \item Binomial likelihoods
 }
}

\examples{
 data(tasab)
 head(tasab,20)
 table(tasab$site,tasab$sex)
}
