% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mqmf_utils.r
\name{plotfishM}
\alias{plotfishM}
\title{plotfishM plots the catch and optionally the cpue}
\usage{
plotfishM(
  fish,
  spsname = "",
  ce = TRUE,
  title = TRUE,
  fnt = 7,
  both = TRUE,
  maxy = c(0, 0),
  year = "year",
  catch = "catch",
  cpue = "cpue"
)
}
\arguments{
\item{fish}{the matrix or data.frame containing year, catch, and cpue.}

\item{spsname}{the name of the species concerned}

\item{ce}{a logical parameter determining whether to plot the cpue or not.
the default = TRUE}

\item{title}{determines whether or not the spsname is printed at the top
of the plot. Default = TRUE but for a more formal publication it
might need to be set to FALSE, which also reallocates the room
given to the title to the plot.}

\item{fnt}{the font used in the plot and axes.}

\item{both}{plot both the catches and the CPUE}

\item{maxy}{a vector of two zeros. These define the maximum y-axis value
for each plot. If it remains zero then getmax will be used to find
the maximum.}

\item{year}{the name of the column containing the years, default="year"}

\item{catch}{the name of the column containing catches, default="catch"}

\item{cpue}{the name of the column containing cpue, default="cpue"}
}
\value{
plots a graph but returns nothing to the console
}
\description{
plotfishM uses a matrix of fishery data. It requires 
    the matrix or data.frame to contain the columns 'year', 
    'catch', and optionally 'cpue'.
}
\examples{
\dontrun{
  data(dataspm)
  plotfishM(fish=dataspm,spsname="Pink Ling",ce=TRUE)
}
}
