% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm.r
\name{fitSPM}
\alias{fitSPM}
\title{fitSPM fits a surplus production model}
\usage{
fitSPM(
  pars,
  fish,
  schaefer = TRUE,
  maxiter = 1000,
  funk = simpspm,
  funkone = TRUE,
  hess = FALSE,
  steptol = 1e-06
)
}
\arguments{
\item{pars}{the initial parameter values to start the search for the 
optimum. These need to be on the log-scale (log-transformed)}

\item{fish}{the matrix containing the fishery data 'year', 'catch', and
'cpue' as a minimum. These exact headings are required.}

\item{schaefer}{if TRUE, the default, then simpspm is used to fit the
Schaefer model. If FALSE then the approximate Fox model is fitted 
by setting the p parameter to 1e-08 inside simpspm.}

\item{maxiter}{the maximum number of iterations to be used by nlm}

\item{funk}{the function used to generate the predicted cpue}

\item{funkone}{default = TRUE. Means use negLL1, which constrains the
first parameter (r) to be greater than 0. If FALSE then use negLL
which is identical to negLL1 but lacks the constraint.}

\item{hess}{default is FALSE; should one calculate the hessian matrix?}

\item{steptol}{the internal step tolerance, required in case nlm reports
the steptol as being too small. defaults to 1e-06}
}
\value{
an nlm output object as a list
}
\description{
fitSPM fits a surplus production model (either Schaefer or 
    Fox) by applying first optim (using Nelder-Mead) and then nlm. Being 
    automated it is recommended that this only be used once plausible 
    initial parameters have been identified (through rules of thumb or 
    trial and error). It uses negLL1 to apply a negative log-likelihood, 
    assuming log-normal residual errors and uses a penalty to prevent 
    the first parameter from becoming < 0.0. If that is not wanted then
    set funkone to FALSE, which would then use negLL by itself.
    The output object is the usual object output from nlm, which can 
    be neatly printed using the MQMF function outfit.
    The $estimate values can be used in plotspmmod to plot the 
    outcome, or in spmboot to conduct bootstrap sampling of the residuals 
    from the CPUE model fit to gain an appreciation of any uncertainty 
    in the analysis. Because it requires log(parametrs) it does not 
    use the magnitude function to set the values of the parscale 
    parameters.
}
\examples{
 data(dataspm) 
 dataspm <- as.matrix(dataspm) # faster than a data.frame
 pars <- log(c(r=0.2,K=6000,Binit=2800,sigma=0.2))
 ans <- fitSPM(pars,fish=dataspm,schaefer=TRUE,maxiter=1000)
 outfit(ans)   # Schaefer model  -12.12879
 ansF <- fitSPM(pars,dataspm,schaefer=FALSE,maxiter=1000)
 outfit(ansF)  # Fox model       -12.35283 
}
