% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGenotypeCalls.R
\name{getGenotypeCalls}
\alias{getGenotypeCalls}
\title{Extract genotype calls from aroma files}
\usage{
getGenotypeCalls(dataSetName, chromosome, listOfFiles = NULL, verbose = TRUE)
}
\arguments{
\item{dataSetName}{The name of the data-set folder (it must correspond to a folder name in rawData folder.)}

\item{chromosome}{A vector containing the chromosomes for which the genotype call will be extracted.}

\item{listOfFiles}{A vector containing the names of the files in dataSetName folder for which the genotype signal will be extracted (default is all the files).}

\item{verbose}{If TRUE print some information (default=TRUE)}
}
\value{
a list of length the number of chromosomes containing a data.frame with columns:
\describe{
  \item{chromosome}{Chromosome of the signal.}
  \item{position}{Positions associated with the genotype.}
  \item{genotype}{Genotype calls corresponding to selected files; the name of each column is the name of the associated data file name.}
  \item{featureNames}{Names of the probes.}
}
}
\description{
Extract genotype calls from aroma files. It requires to have executed the normalization process suggested by aroma packages, by using 
\link{signalPreProcess} for example.
}
\details{
The aroma architecture must be respected. The working directory must contain rawData folder and totalAndFracBData folder.
To easily access the names of the files available in a dataset, one can use the \link{getListOfFiles} function.
}
\examples{
\dontrun{
#DO NOT EXECUTE before reading the vignette
fracB=getGenotypeCalls("data1",5)
}

}
\author{
Quentin Grimonprez
}
