% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variation_polymut.R
\name{variation_polymut}
\alias{variation_polymut}
\title{Polynomial mutation}
\usage{
variation_polymut(X, etam, pm, eps = 1e-06, ...)
}
\arguments{
\item{X}{Population matrix}

\item{etam}{mutation constant}

\item{pm}{variable-wise probability of mutation (numeric value 0 <= pm <= 1,
or use "n" for setting it as (1 / problem dimension).)}

\item{eps}{small constant used to prevent divisions by zero}

\item{...}{other parameters (included for compatibility with generic call)}
}
\value{
Matrix \code{X}' containing the mutated population
}
\description{
Polynomial mutation implementation for the MOEA/D
}
\details{
This R implementation of the Polynomial Mutation reproduces the C code
implementation available in the R package \strong{emoa} 0.5-0, by Olaf Mersmann.
The differences between the present version and the original one are:
\itemize{
\item The operator is performed on the variables scaled to the \verb{[0, 1]}
interval, which simplifies the calculations.
\item Calculations are vectorized over variables, which also simplifies
the implementation.
}
}
\section{References}{

K. Deb and S. Agrawal (1999). A Niched-Penalty Approach for Constraint
Handling in Genetic Algorithms. In: Artificial Neural Nets and Genetic
Algorithms, pp. 235-243, Springer.\cr

F. Campelo, L.S. Batista, C. Aranha (2020): The {MOEADr} Package: A
Component-Based Framework for Multiobjective Evolutionary Algorithms Based on
Decomposition. Journal of Statistical Software \doi{10.18637/jss.v092.i06}\cr

Olaf Mersmann (2012). emoa: Evolutionary Multiobjective
Optimization Algorithms. R package version 0.5-0.\cr
http://CRAN.R-project.org/package=emoa
}

