% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stop_maxiter.R
\name{stop_maxiter}
\alias{stop_maxiter}
\title{Stop criterion: maximum number of iterations}
\usage{
stop_maxiter(stopcrit, iter, ...)
}
\arguments{
\item{stopcrit}{list containing the parameters defining the stop
handling method. See Section \code{Constraint Handling} of the \code{\link[=moead]{moead()}}
documentation for details.}

\item{iter}{iterations counter of \code{\link[=moead]{moead()}}.}

\item{...}{other parameters (included for compatibility with generic call)}
}
\value{
boolean value: \code{TRUE} if this criterion has been met, \code{FALSE}
otherwise.
}
\description{
Verifies stop criterion "maximum number of iterations" for the MOEADr
package. For internal use only, not to be called directly by the user.
}
\details{
When this stop criterion is used, one element of the \code{stopcrit}
parameter (see \code{\link[=moead]{moead()}}) must have the following structure:
\itemize{
\item \code{stopcrit$name = "maxiter"}
\item \code{stopcrit$maxiter}, containing a positive integer representing the
desired maximum number of iterations.
}
}
